unit dotNetAppForm;

interface

uses
  System.Security,
  System.Runtime.InteropServices,
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  frmPInvoke = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnTiming: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnTiming_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(frmPInvoke))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure frmPInvoke.InitializeComponent;
begin
  Self.btnTiming := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // btnTiming
  // 
  Self.btnTiming.Location := System.Drawing.Point.Create(73, 23);
  Self.btnTiming.Name := 'btnTiming';
  Self.btnTiming.Size := System.Drawing.Size.Create(240, 23);
  Self.btnTiming.TabIndex := 0;
  Self.btnTiming.Text := 'Accurate Timing';
  Include(Self.btnTiming.Click, Self.btnTiming_Click);
  // 
  // frmPInvoke
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(6, 15);
  Self.ClientSize := System.Drawing.Size.Create(402, 66);
  Self.Controls.Add(Self.btnTiming);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Name := 'frmPInvoke';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := '.NET App Using Win32 Timing Routines';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure frmPInvoke.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor frmPInvoke.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
{.$define PRELINK_INDIVIDUALLY}
{$ifdef PRELINK_INDIVIDUALLY}
  Marshal.Prelink(GetType.Module.GetType('dotNetApp.Unit').GetMethod('QueryPerformanceFrequency'));
  Marshal.Prelink(GetType.Module.GetType('dotNetApp.Unit').GetMethod('QueryPerformanceCounter'));
{$else}
  //Prelink and load all PInvoke routines in this module
  //(an object can tell you its module)
  Marshal.PrelinkAll(GetType.Module.GetType('dotNetApp.Unit'));
{$endif}
end;

//Define one of these three conditional symbols
{.$define LOGICAL_TRANSLATION}
{.$define ACCURATE_TRANSLATION}
{$define EFFICIENT_TRANSLATION} 

const
  kernel32  = 'kernel32.dll';

{$ifdef LOGICAL_TRANSLATION}
function QueryPerformanceCounter(var lpPerformanceCount: Int64): Boolean; stdcall;
external kernel32;

function QueryPerformanceFrequency(var lpFrequency: Int64): Boolean; stdcall;
external kernel32;
{$endif}
{$ifdef ACCURATE_TRANSLATION}
function QueryPerformanceCounter(out lpPerformanceCount: Int64): LongBool; stdcall;
external kernel32;

function QueryPerformanceFrequency(out lpFrequency: Int64): LongBool; stdcall;
external kernel32;
{$endif}
{$ifdef EFFICIENT_TRANSLATION}
[DllImport(kernel32), SuppressUnmanagedCodeSecurity]
function QueryPerformanceCounter(out lpPerformanceCount: Int64): LongBool;
external;

[DllImport(kernel32), SuppressUnmanagedCodeSecurity]
function QueryPerformanceFrequency(out lpFrequency: Int64): LongBool;
external;
{$endif}

procedure frmPInvoke.btnTiming_Click(sender: System.Object; e: System.EventArgs);
var
  StartTime, EndTime, TimerFrequency: Int64;
  TimeDiff, SqrRoot: Double;
  I: Integer;
const
  NumIterations = 100000000;

  procedure TimerError;
  begin
    raise Exception.Create('High accuracy timing not supported on this machine')
  end;

begin
  if not QueryPerformanceFrequency(TimerFrequency) then
    TimerError;
  if not QueryPerformanceCounter(StartTime) then
    TimerError;
  for I := 1 to NumIterations do
    SqrRoot := Sqrt(2);
  if not QueryPerformanceCounter(EndTime) then
    TimerError;
  TimeDiff := (EndTime - StartTime) / TimerFrequency;
  MessageBox.Show(
    System.String.Format(
      '{0:n0} square roots takes {1:g6} seconds',
      [NumIterations * 1.0, TimeDiff]),
    'Timing Results', MessageBoxButtons.OK, MessageBoxIcon.Information)
end;

end.
